' runinst.vbs: run commands in the given folder
'
' USAGE
'
'   runinst.vbs FOLDER
'
'   FOLDER  Path of folder containing installations to run
'
' NOTES
'
'   This script supports files with the extensions EXE,
'   MSI, BAT, CMD, JS, VBS, REG, and INF.
'
'   If the folder doesn't exist, this script displays an error
'   message that times out in 10 seconds, since it's for use during
'   the Windows setup process and the folder doesn't always exist.
'

Option Explicit

Main()

Sub Main()

  ' Check the command-line argument (which must be the path of
  ' a folder that contains installations to run); then, call
  ' LaunchInstallations to silently run each installation contained
  ' in the folder.
  '
  Dim intRC
  Dim objArguments
  Dim objFileSystem
  Dim objShell

  Set objArguments = WScript.Arguments
  Set objFilesystem = CreateObject( "Scripting.FileSystemObject" )
  Set objShell = CreateObject( "WScript.Shell" )

  If objArguments.Count > 0 Then
    If objFileSystem.FolderExists( objArguments(0) ) Then
      LaunchInstallations( objArguments(0) )
    Else

      ' The folder doesn't exist

      intRC = objShell.Popup( "The folder " & objArguments(0) & _
                 " doesn't exist.", 10, "Folder Missing", 0 )

    End If

  Else

    ' No folder was given on the command line

    WScript.Echo "Usage: runinst.vbs FOLDER"

  End If

End Sub

Sub LaunchInstallations( strPath )

  ' Execute each installation file contained in strPath silently:
  '
  '   strPath Path of the folder containing installations
  '

  Dim objFileSystem
  Dim objShell

  Set objFilesystem = CreateObject( "Scripting.FileSystemObject" )
  Set objShell = CreateObject( "WScript.Shell" )

  ' Build a list of files in the given subfolder

  Dim intRC
  Dim objFolder
  Dim colFiles
  Dim objFile

  Set objFolder = objFileSystem.GetFolder( strPath )
  Set colFiles = objFolder.Files

  ' Launch each file in the list using the appropriate command

  For Each objFile in colFiles
    Select Case UCase( objFileSystem.GetExtensionName( objFile ))

      Case "EXE"
        intRC = objShell.Run( objFile, 1, True )

      case "MSI"

        Dim objWMIService
        Dim strProcessName

      ' Wait for any current MSI processes to finish

        strProcessName = "msiexec.exe"
        Set objWMIService = GetObject("winmgmts:\\.\root\cimv2")

        Do While objWMIService.ExecQuery( "Select Name from _
           Win32_Process where Name='" & strProcessName & "'").Count > 1
          WScript.Sleep 5000
        Loop

        intRC = objShell.Run( "msiexec.exe /qb /i " & _
                             objFile & " ALLUSERS=2", 1, True )

      Case "BAT"
        intRC = objShell.Run( "cmd.exe /c " & objFile, 1, True )

      Case "CMD"
        intRC = objShell.Run( "cmd.exe /c " & objFile, 1, True )

      Case "JS"
        intRC = objShell.Run( "wscript.exe //e:jscript " & _
                         objFile, 1, True )

      Case "VBS"
        intRC = objShell.Run( "wscript.exe //e:vbscript " & objFile, 1, True )

      Case "REG"
        intRC = objShell.Run( "regedit.exe /s " & objFile, 1, True )

      Case "INF"
        intRC = objShell.Run( _
        "rundll32.exe setupapi,InstallHinfSection DefaultInstall 132 " _
        & objFile, 1, True )

    End Select
  Next

End Sub
